# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class MasterDetailsResponsePlanInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'currency_code': 'str',
        'next_billing_at': 'int',
        'price': 'float',
        'plan_period': 'str',
        'sub_accounts': 'int',
        'features': 'list[MasterDetailsResponsePlanInfoFeatures]'
    }

    attribute_map = {
        'currency_code': 'currencyCode',
        'next_billing_at': 'nextBillingAt',
        'price': 'price',
        'plan_period': 'planPeriod',
        'sub_accounts': 'subAccounts',
        'features': 'features'
    }

    def __init__(self, currency_code=None, next_billing_at=None, price=None, plan_period=None, sub_accounts=None, features=None):  # noqa: E501
        """MasterDetailsResponsePlanInfo - a model defined in Swagger"""  # noqa: E501

        self._currency_code = None
        self._next_billing_at = None
        self._price = None
        self._plan_period = None
        self._sub_accounts = None
        self._features = None
        self.discriminator = None

        if currency_code is not None:
            self.currency_code = currency_code
        if next_billing_at is not None:
            self.next_billing_at = next_billing_at
        if price is not None:
            self.price = price
        if plan_period is not None:
            self.plan_period = plan_period
        if sub_accounts is not None:
            self.sub_accounts = sub_accounts
        if features is not None:
            self.features = features

    @property
    def currency_code(self):
        """Gets the currency_code of this MasterDetailsResponsePlanInfo.  # noqa: E501

        Plan currency  # noqa: E501

        :return: The currency_code of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """Sets the currency_code of this MasterDetailsResponsePlanInfo.

        Plan currency  # noqa: E501

        :param currency_code: The currency_code of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :type: str
        """

        self._currency_code = currency_code

    @property
    def next_billing_at(self):
        """Gets the next_billing_at of this MasterDetailsResponsePlanInfo.  # noqa: E501

        Timestamp of next billing date  # noqa: E501

        :return: The next_billing_at of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :rtype: int
        """
        return self._next_billing_at

    @next_billing_at.setter
    def next_billing_at(self, next_billing_at):
        """Sets the next_billing_at of this MasterDetailsResponsePlanInfo.

        Timestamp of next billing date  # noqa: E501

        :param next_billing_at: The next_billing_at of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :type: int
        """

        self._next_billing_at = next_billing_at

    @property
    def price(self):
        """Gets the price of this MasterDetailsResponsePlanInfo.  # noqa: E501

        Plan amount  # noqa: E501

        :return: The price of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this MasterDetailsResponsePlanInfo.

        Plan amount  # noqa: E501

        :param price: The price of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :type: float
        """

        self._price = price

    @property
    def plan_period(self):
        """Gets the plan_period of this MasterDetailsResponsePlanInfo.  # noqa: E501

        Plan period type  # noqa: E501

        :return: The plan_period of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :rtype: str
        """
        return self._plan_period

    @plan_period.setter
    def plan_period(self, plan_period):
        """Sets the plan_period of this MasterDetailsResponsePlanInfo.

        Plan period type  # noqa: E501

        :param plan_period: The plan_period of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :type: str
        """
        allowed_values = ["month", "year"]  # noqa: E501
        if plan_period not in allowed_values:
            raise ValueError(
                "Invalid value for `plan_period` ({0}), must be one of {1}"  # noqa: E501
                .format(plan_period, allowed_values)
            )

        self._plan_period = plan_period

    @property
    def sub_accounts(self):
        """Gets the sub_accounts of this MasterDetailsResponsePlanInfo.  # noqa: E501

        Number of sub-accounts  # noqa: E501

        :return: The sub_accounts of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :rtype: int
        """
        return self._sub_accounts

    @sub_accounts.setter
    def sub_accounts(self, sub_accounts):
        """Sets the sub_accounts of this MasterDetailsResponsePlanInfo.

        Number of sub-accounts  # noqa: E501

        :param sub_accounts: The sub_accounts of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :type: int
        """

        self._sub_accounts = sub_accounts

    @property
    def features(self):
        """Gets the features of this MasterDetailsResponsePlanInfo.  # noqa: E501

        List of provided features in the plan  # noqa: E501

        :return: The features of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :rtype: list[MasterDetailsResponsePlanInfoFeatures]
        """
        return self._features

    @features.setter
    def features(self, features):
        """Sets the features of this MasterDetailsResponsePlanInfo.

        List of provided features in the plan  # noqa: E501

        :param features: The features of this MasterDetailsResponsePlanInfo.  # noqa: E501
        :type: list[MasterDetailsResponsePlanInfoFeatures]
        """

        self._features = features

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MasterDetailsResponsePlanInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MasterDetailsResponsePlanInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
