# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class GetScheduledEmailByMessageId(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'scheduled_at': 'datetime',
        'created_at': 'datetime',
        'status': 'str'
    }

    attribute_map = {
        'scheduled_at': 'scheduledAt',
        'created_at': 'createdAt',
        'status': 'status'
    }

    def __init__(self, scheduled_at=None, created_at=None, status=None):  # noqa: E501
        """GetScheduledEmailByMessageId - a model defined in Swagger"""  # noqa: E501

        self._scheduled_at = None
        self._created_at = None
        self._status = None
        self.discriminator = None

        self.scheduled_at = scheduled_at
        self.created_at = created_at
        self.status = status

    @property
    def scheduled_at(self):
        """Gets the scheduled_at of this GetScheduledEmailByMessageId.  # noqa: E501

        Datetime for which the email was scheduled  # noqa: E501

        :return: The scheduled_at of this GetScheduledEmailByMessageId.  # noqa: E501
        :rtype: datetime
        """
        return self._scheduled_at

    @scheduled_at.setter
    def scheduled_at(self, scheduled_at):
        """Sets the scheduled_at of this GetScheduledEmailByMessageId.

        Datetime for which the email was scheduled  # noqa: E501

        :param scheduled_at: The scheduled_at of this GetScheduledEmailByMessageId.  # noqa: E501
        :type: datetime
        """
        if scheduled_at is None:
            raise ValueError("Invalid value for `scheduled_at`, must not be `None`")  # noqa: E501

        self._scheduled_at = scheduled_at

    @property
    def created_at(self):
        """Gets the created_at of this GetScheduledEmailByMessageId.  # noqa: E501

        Datetime on which the email was scheduled  # noqa: E501

        :return: The created_at of this GetScheduledEmailByMessageId.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this GetScheduledEmailByMessageId.

        Datetime on which the email was scheduled  # noqa: E501

        :param created_at: The created_at of this GetScheduledEmailByMessageId.  # noqa: E501
        :type: datetime
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def status(self):
        """Gets the status of this GetScheduledEmailByMessageId.  # noqa: E501

        Current status of the scheduled email  # noqa: E501

        :return: The status of this GetScheduledEmailByMessageId.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this GetScheduledEmailByMessageId.

        Current status of the scheduled email  # noqa: E501

        :param status: The status of this GetScheduledEmailByMessageId.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["inProgress", "queued", "processed", "error"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetScheduledEmailByMessageId, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetScheduledEmailByMessageId):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
