# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CreateSenderIps(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ip': 'str',
        'domain': 'str',
        'weight': 'int'
    }

    attribute_map = {
        'ip': 'ip',
        'domain': 'domain',
        'weight': 'weight'
    }

    def __init__(self, ip=None, domain=None, weight=None):  # noqa: E501
        """CreateSenderIps - a model defined in Swagger"""  # noqa: E501

        self._ip = None
        self._domain = None
        self._weight = None
        self.discriminator = None

        self.ip = ip
        self.domain = domain
        if weight is not None:
            self.weight = weight

    @property
    def ip(self):
        """Gets the ip of this CreateSenderIps.  # noqa: E501

        Dedicated IP available in your account  # noqa: E501

        :return: The ip of this CreateSenderIps.  # noqa: E501
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """Sets the ip of this CreateSenderIps.

        Dedicated IP available in your account  # noqa: E501

        :param ip: The ip of this CreateSenderIps.  # noqa: E501
        :type: str
        """
        if ip is None:
            raise ValueError("Invalid value for `ip`, must not be `None`")  # noqa: E501

        self._ip = ip

    @property
    def domain(self):
        """Gets the domain of this CreateSenderIps.  # noqa: E501

        Domain of the IP  # noqa: E501

        :return: The domain of this CreateSenderIps.  # noqa: E501
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this CreateSenderIps.

        Domain of the IP  # noqa: E501

        :param domain: The domain of this CreateSenderIps.  # noqa: E501
        :type: str
        """
        if domain is None:
            raise ValueError("Invalid value for `domain`, must not be `None`")  # noqa: E501

        self._domain = domain

    @property
    def weight(self):
        """Gets the weight of this CreateSenderIps.  # noqa: E501

        Weight to apply to the IP. Sum of all IP weights must be 100. Should be passed for either ALL or NONE of the IPs. If it's not passed, the sending will be equally balanced on all IPs.  # noqa: E501

        :return: The weight of this CreateSenderIps.  # noqa: E501
        :rtype: int
        """
        return self._weight

    @weight.setter
    def weight(self, weight):
        """Sets the weight of this CreateSenderIps.

        Weight to apply to the IP. Sum of all IP weights must be 100. Should be passed for either ALL or NONE of the IPs. If it's not passed, the sending will be equally balanced on all IPs.  # noqa: E501

        :param weight: The weight of this CreateSenderIps.  # noqa: E501
        :type: int
        """
        if weight is not None and weight > 100:  # noqa: E501
            raise ValueError("Invalid value for `weight`, must be a value less than or equal to `100`")  # noqa: E501
        if weight is not None and weight < 1:  # noqa: E501
            raise ValueError("Invalid value for `weight`, must be a value greater than or equal to `1`")  # noqa: E501

        self._weight = weight

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateSenderIps, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateSenderIps):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
