# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Contact(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'virtual_next_task': 'object',
        'email': 'str',
        'assign_to_id': 'str',
        'contacts_id': 'int',
        'crm_lists': 'object',
        'attributes': 'object',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'virtual_next_task': 'virtualNextTask',
        'email': 'email',
        'assign_to_id': 'assignToId',
        'contacts_id': 'contactsId',
        'crm_lists': 'crmLists',
        'attributes': 'attributes',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, virtual_next_task=None, email=None, assign_to_id=None, contacts_id=None, crm_lists=None, attributes=None, created_at=None, updated_at=None):  # noqa: E501
        """Contact - a model defined in Swagger"""  # noqa: E501

        self._virtual_next_task = None
        self._email = None
        self._assign_to_id = None
        self._contacts_id = None
        self._crm_lists = None
        self._attributes = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        if virtual_next_task is not None:
            self.virtual_next_task = virtual_next_task
        self.email = email
        if assign_to_id is not None:
            self.assign_to_id = assign_to_id
        if contacts_id is not None:
            self.contacts_id = contacts_id
        self.crm_lists = crm_lists
        if attributes is not None:
            self.attributes = attributes
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def virtual_next_task(self):
        """Gets the virtual_next_task of this Contact.  # noqa: E501

        Next incomplete task of contact  # noqa: E501

        :return: The virtual_next_task of this Contact.  # noqa: E501
        :rtype: object
        """
        return self._virtual_next_task

    @virtual_next_task.setter
    def virtual_next_task(self, virtual_next_task):
        """Sets the virtual_next_task of this Contact.

        Next incomplete task of contact  # noqa: E501

        :param virtual_next_task: The virtual_next_task of this Contact.  # noqa: E501
        :type: object
        """

        self._virtual_next_task = virtual_next_task

    @property
    def email(self):
        """Gets the email of this Contact.  # noqa: E501

        Contact email  # noqa: E501

        :return: The email of this Contact.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Contact.

        Contact email  # noqa: E501

        :param email: The email of this Contact.  # noqa: E501
        :type: str
        """
        if email is None:
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def assign_to_id(self):
        """Gets the assign_to_id of this Contact.  # noqa: E501

        User id to whom contact is assigned  # noqa: E501

        :return: The assign_to_id of this Contact.  # noqa: E501
        :rtype: str
        """
        return self._assign_to_id

    @assign_to_id.setter
    def assign_to_id(self, assign_to_id):
        """Sets the assign_to_id of this Contact.

        User id to whom contact is assigned  # noqa: E501

        :param assign_to_id: The assign_to_id of this Contact.  # noqa: E501
        :type: str
        """

        self._assign_to_id = assign_to_id

    @property
    def contacts_id(self):
        """Gets the contacts_id of this Contact.  # noqa: E501

        Contact id  # noqa: E501

        :return: The contacts_id of this Contact.  # noqa: E501
        :rtype: int
        """
        return self._contacts_id

    @contacts_id.setter
    def contacts_id(self, contacts_id):
        """Sets the contacts_id of this Contact.

        Contact id  # noqa: E501

        :param contacts_id: The contacts_id of this Contact.  # noqa: E501
        :type: int
        """

        self._contacts_id = contacts_id

    @property
    def crm_lists(self):
        """Gets the crm_lists of this Contact.  # noqa: E501

        CRM lists in which contact is added  # noqa: E501

        :return: The crm_lists of this Contact.  # noqa: E501
        :rtype: object
        """
        return self._crm_lists

    @crm_lists.setter
    def crm_lists(self, crm_lists):
        """Sets the crm_lists of this Contact.

        CRM lists in which contact is added  # noqa: E501

        :param crm_lists: The crm_lists of this Contact.  # noqa: E501
        :type: object
        """
        if crm_lists is None:
            raise ValueError("Invalid value for `crm_lists`, must not be `None`")  # noqa: E501

        self._crm_lists = crm_lists

    @property
    def attributes(self):
        """Gets the attributes of this Contact.  # noqa: E501

        Contact attributes e.g firstname / lastname / SMS etc.  # noqa: E501

        :return: The attributes of this Contact.  # noqa: E501
        :rtype: object
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """Sets the attributes of this Contact.

        Contact attributes e.g firstname / lastname / SMS etc.  # noqa: E501

        :param attributes: The attributes of this Contact.  # noqa: E501
        :type: object
        """

        self._attributes = attributes

    @property
    def created_at(self):
        """Gets the created_at of this Contact.  # noqa: E501

        Contact created date/time  # noqa: E501

        :return: The created_at of this Contact.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Contact.

        Contact created date/time  # noqa: E501

        :param created_at: The created_at of this Contact.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Contact.  # noqa: E501

        Contact updated date/time  # noqa: E501

        :return: The updated_at of this Contact.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Contact.

        Contact updated date/time  # noqa: E501

        :param updated_at: The updated_at of this Contact.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Contact, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Contact):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
