# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sib_api_v3_sdk.api_client import ApiClient


class TransactionalEmailsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def block_new_domain(self, block_domain, **kwargs):  # noqa: E501
        """Add a new domain to the list of blocked domains  # noqa: E501

        Blocks a new domain in order to avoid messages being sent to the same  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.block_new_domain(block_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BlockDomain block_domain: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.block_new_domain_with_http_info(block_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.block_new_domain_with_http_info(block_domain, **kwargs)  # noqa: E501
            return data

    def block_new_domain_with_http_info(self, block_domain, **kwargs):  # noqa: E501
        """Add a new domain to the list of blocked domains  # noqa: E501

        Blocks a new domain in order to avoid messages being sent to the same  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.block_new_domain_with_http_info(block_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BlockDomain block_domain: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['block_domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method block_new_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'block_domain' is set
        if ('block_domain' not in params or
                params['block_domain'] is None):
            raise ValueError("Missing the required parameter `block_domain` when calling `block_new_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'block_domain' in params:
            body_params = params['block_domain']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/blockedDomains', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_smtp_template(self, smtp_template, **kwargs):  # noqa: E501
        """Create an email template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_smtp_template(smtp_template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSmtpTemplate smtp_template: values to update in transactional email template (required)
        :return: CreateModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_smtp_template_with_http_info(smtp_template, **kwargs)  # noqa: E501
        else:
            (data) = self.create_smtp_template_with_http_info(smtp_template, **kwargs)  # noqa: E501
            return data

    def create_smtp_template_with_http_info(self, smtp_template, **kwargs):  # noqa: E501
        """Create an email template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_smtp_template_with_http_info(smtp_template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSmtpTemplate smtp_template: values to update in transactional email template (required)
        :return: CreateModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smtp_template']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_smtp_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smtp_template' is set
        if ('smtp_template' not in params or
                params['smtp_template'] is None):
            raise ValueError("Missing the required parameter `smtp_template` when calling `create_smtp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smtp_template' in params:
            body_params = params['smtp_template']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/templates', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_blocked_domain(self, domain, **kwargs):  # noqa: E501
        """Unblock an existing domain from the list of blocked domains  # noqa: E501

        Unblocks an existing domain from the list of blocked domains  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_blocked_domain(domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: The name of the domain to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_blocked_domain_with_http_info(domain, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_blocked_domain_with_http_info(domain, **kwargs)  # noqa: E501
            return data

    def delete_blocked_domain_with_http_info(self, domain, **kwargs):  # noqa: E501
        """Unblock an existing domain from the list of blocked domains  # noqa: E501

        Unblocks an existing domain from the list of blocked domains  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_blocked_domain_with_http_info(domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: The name of the domain to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_blocked_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `delete_blocked_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/blockedDomains/{domain}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hardbounces(self, **kwargs):  # noqa: E501
        """Delete hardbounces  # noqa: E501

        Delete hardbounces. To use carefully (e.g. in case of temporary ISP failures)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hardbounces(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteHardbounces delete_hardbounces: values to delete hardbounces
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_hardbounces_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_hardbounces_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_hardbounces_with_http_info(self, **kwargs):  # noqa: E501
        """Delete hardbounces  # noqa: E501

        Delete hardbounces. To use carefully (e.g. in case of temporary ISP failures)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hardbounces_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteHardbounces delete_hardbounces: values to delete hardbounces
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delete_hardbounces']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hardbounces" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'delete_hardbounces' in params:
            body_params = params['delete_hardbounces']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/deleteHardbounces', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_scheduled_email_by_id(self, identifier, **kwargs):  # noqa: E501
        """Delete scheduled emails by batchId or messageId  # noqa: E501

        Delete scheduled batch of emails by batchId or single scheduled email by messageId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scheduled_email_by_id(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: The `batchId` of scheduled emails batch (Should be a valid UUIDv4) or the `messageId` of scheduled email. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scheduled_email_by_id_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scheduled_email_by_id_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def delete_scheduled_email_by_id_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Delete scheduled emails by batchId or messageId  # noqa: E501

        Delete scheduled batch of emails by batchId or single scheduled email by messageId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scheduled_email_by_id_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: The `batchId` of scheduled emails batch (Should be a valid UUIDv4) or the `messageId` of scheduled email. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scheduled_email_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_scheduled_email_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/email/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smtp_template(self, template_id, **kwargs):  # noqa: E501
        """Delete an inactive email template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smtp_template(template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: id of the template (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_smtp_template_with_http_info(template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_smtp_template_with_http_info(template_id, **kwargs)  # noqa: E501
            return data

    def delete_smtp_template_with_http_info(self, template_id, **kwargs):  # noqa: E501
        """Delete an inactive email template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smtp_template_with_http_info(template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: id of the template (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smtp_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_smtp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/templates/{templateId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_aggregated_smtp_report(self, **kwargs):  # noqa: E501
        """Get your transactional email activity aggregated over a period of time  # noqa: E501

        This endpoint will show the aggregated stats for past 90 days by default if `startDate` and `endDate` OR `days` is not passed. The date range can not exceed 90 days  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aggregated_smtp_report(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str start_date: Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate
        :param str end_date: Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate
        :param int days: Number of days in the past including today (positive integer). Not compatible with 'startDate' and 'endDate'
        :param str tag: Tag of the emails
        :return: GetAggregatedReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_aggregated_smtp_report_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_aggregated_smtp_report_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_aggregated_smtp_report_with_http_info(self, **kwargs):  # noqa: E501
        """Get your transactional email activity aggregated over a period of time  # noqa: E501

        This endpoint will show the aggregated stats for past 90 days by default if `startDate` and `endDate` OR `days` is not passed. The date range can not exceed 90 days  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aggregated_smtp_report_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str start_date: Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate
        :param str end_date: Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate
        :param int days: Number of days in the past including today (positive integer). Not compatible with 'startDate' and 'endDate'
        :param str tag: Tag of the emails
        :return: GetAggregatedReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_date', 'end_date', 'days', 'tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_aggregated_smtp_report" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/statistics/aggregatedReport', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAggregatedReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_blocked_domains(self, **kwargs):  # noqa: E501
        """Get the list of blocked domains  # noqa: E501

        Get the list of blocked domains  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blocked_domains(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GetBlockedDomains
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_blocked_domains_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_blocked_domains_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_blocked_domains_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of blocked domains  # noqa: E501

        Get the list of blocked domains  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blocked_domains_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GetBlockedDomains
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_blocked_domains" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/blockedDomains', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetBlockedDomains',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_event_report(self, **kwargs):  # noqa: E501
        """Get all your transactional email activity (unaggregated events)  # noqa: E501

        This endpoint will show the aggregated stats for past 30 days by default if `startDate` and `endDate` OR `days` is not passed. The date range can not exceed 90 days  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_event_report(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number limitation for the result returned
        :param int offset: Beginning point in the list to retrieve from.
        :param str start_date: Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate
        :param str end_date: Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate
        :param int days: Number of days in the past including today (positive integer). Not compatible with 'startDate' and 'endDate'
        :param str email: Filter the report for a specific email addresses
        :param str event: Filter the report for a specific event type
        :param str tags: Filter the report for tags (serialized and urlencoded array)
        :param str message_id: Filter on a specific message id
        :param int template_id: Filter on a specific template id
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :return: GetEmailEventReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_event_report_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_email_event_report_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_email_event_report_with_http_info(self, **kwargs):  # noqa: E501
        """Get all your transactional email activity (unaggregated events)  # noqa: E501

        This endpoint will show the aggregated stats for past 30 days by default if `startDate` and `endDate` OR `days` is not passed. The date range can not exceed 90 days  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_event_report_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number limitation for the result returned
        :param int offset: Beginning point in the list to retrieve from.
        :param str start_date: Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate
        :param str end_date: Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate
        :param int days: Number of days in the past including today (positive integer). Not compatible with 'startDate' and 'endDate'
        :param str email: Filter the report for a specific email addresses
        :param str event: Filter the report for a specific event type
        :param str tags: Filter the report for tags (serialized and urlencoded array)
        :param str message_id: Filter on a specific message id
        :param int template_id: Filter on a specific template id
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :return: GetEmailEventReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'start_date', 'end_date', 'days', 'email', 'event', 'tags', 'message_id', 'template_id', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_event_report" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 5000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_email_event_report`, must be a value less than or equal to `5000`")  # noqa: E501
        if 'limit' in params and params['limit'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_email_event_report`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501
        if 'email' in params:
            query_params.append(('email', params['email']))  # noqa: E501
        if 'event' in params:
            query_params.append(('event', params['event']))  # noqa: E501
        if 'tags' in params:
            query_params.append(('tags', params['tags']))  # noqa: E501
        if 'message_id' in params:
            query_params.append(('messageId', params['message_id']))  # noqa: E501
        if 'template_id' in params:
            query_params.append(('templateId', params['template_id']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/statistics/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetEmailEventReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scheduled_email_by_batch_id(self, batch_id, **kwargs):  # noqa: E501
        """Fetch scheduled emails by batchId  # noqa: E501

        Fetch scheduled batch of emails by batchId (Can retrieve data upto 30 days old)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scheduled_email_by_batch_id(batch_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str batch_id: The batchId of scheduled emails batch (Should be a valid UUIDv4) (required)
        :param date start_date: Mandatory if `endDate` is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Can be maximum 30 days older tha current date.
        :param date end_date: Mandatory if `startDate` is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month.
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :param str status: Filter the records by `status` of the scheduled email batch or message.
        :param int limit: Number of documents returned per page
        :param int offset: Index of the first document on the page
        :return: GetScheduledEmailByBatchId
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scheduled_email_by_batch_id_with_http_info(batch_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scheduled_email_by_batch_id_with_http_info(batch_id, **kwargs)  # noqa: E501
            return data

    def get_scheduled_email_by_batch_id_with_http_info(self, batch_id, **kwargs):  # noqa: E501
        """Fetch scheduled emails by batchId  # noqa: E501

        Fetch scheduled batch of emails by batchId (Can retrieve data upto 30 days old)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scheduled_email_by_batch_id_with_http_info(batch_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str batch_id: The batchId of scheduled emails batch (Should be a valid UUIDv4) (required)
        :param date start_date: Mandatory if `endDate` is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Can be maximum 30 days older tha current date.
        :param date end_date: Mandatory if `startDate` is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month.
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :param str status: Filter the records by `status` of the scheduled email batch or message.
        :param int limit: Number of documents returned per page
        :param int offset: Index of the first document on the page
        :return: GetScheduledEmailByBatchId
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['batch_id', 'start_date', 'end_date', 'sort', 'status', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scheduled_email_by_batch_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'batch_id' is set
        if ('batch_id' not in params or
                params['batch_id'] is None):
            raise ValueError("Missing the required parameter `batch_id` when calling `get_scheduled_email_by_batch_id`")  # noqa: E501

        if 'limit' in params and params['limit'] > 500:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_scheduled_email_by_batch_id`, must be a value less than or equal to `500`")  # noqa: E501
        if 'limit' in params and params['limit'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_scheduled_email_by_batch_id`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'batch_id' in params:
            path_params['batchId'] = params['batch_id']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/emailStatus/{batchId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetScheduledEmailByBatchId',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scheduled_email_by_message_id(self, message_id, **kwargs):  # noqa: E501
        """Fetch scheduled email by messageId  # noqa: E501

        Fetch scheduled email by messageId (Can retrieve data upto 30 days old)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scheduled_email_by_message_id(message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str message_id: The messageId of scheduled email (required)
        :param date start_date: Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Can be maximum 30 days older tha current date.
        :param date end_date: Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month.
        :return: GetScheduledEmailByMessageId
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scheduled_email_by_message_id_with_http_info(message_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scheduled_email_by_message_id_with_http_info(message_id, **kwargs)  # noqa: E501
            return data

    def get_scheduled_email_by_message_id_with_http_info(self, message_id, **kwargs):  # noqa: E501
        """Fetch scheduled email by messageId  # noqa: E501

        Fetch scheduled email by messageId (Can retrieve data upto 30 days old)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scheduled_email_by_message_id_with_http_info(message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str message_id: The messageId of scheduled email (required)
        :param date start_date: Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Can be maximum 30 days older tha current date.
        :param date end_date: Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month.
        :return: GetScheduledEmailByMessageId
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['message_id', 'start_date', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scheduled_email_by_message_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params or
                params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `get_scheduled_email_by_message_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'message_id' in params:
            path_params['messageId'] = params['message_id']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/emailStatus/{messageId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetScheduledEmailByMessageId',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smtp_report(self, **kwargs):  # noqa: E501
        """Get your transactional email activity aggregated per day  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smtp_report(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents returned per page
        :param int offset: Index of the first document on the page
        :param str start_date: Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD)
        :param str end_date: Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD)
        :param int days: Number of days in the past including today (positive integer). Not compatible with 'startDate' and 'endDate'
        :param str tag: Tag of the emails
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :return: GetReports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smtp_report_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smtp_report_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smtp_report_with_http_info(self, **kwargs):  # noqa: E501
        """Get your transactional email activity aggregated per day  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smtp_report_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents returned per page
        :param int offset: Index of the first document on the page
        :param str start_date: Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD)
        :param str end_date: Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD)
        :param int days: Number of days in the past including today (positive integer). Not compatible with 'startDate' and 'endDate'
        :param str tag: Tag of the emails
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :return: GetReports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'start_date', 'end_date', 'days', 'tag', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smtp_report" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 30:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_smtp_report`, must be a value less than or equal to `30`")  # noqa: E501
        if 'limit' in params and params['limit'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_smtp_report`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/statistics/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetReports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smtp_template(self, template_id, **kwargs):  # noqa: E501
        """Returns the template information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smtp_template(template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: id of the template (required)
        :return: GetSmtpTemplateOverview
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smtp_template_with_http_info(template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_smtp_template_with_http_info(template_id, **kwargs)  # noqa: E501
            return data

    def get_smtp_template_with_http_info(self, template_id, **kwargs):  # noqa: E501
        """Returns the template information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smtp_template_with_http_info(template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: id of the template (required)
        :return: GetSmtpTemplateOverview
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smtp_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_smtp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/templates/{templateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSmtpTemplateOverview',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smtp_templates(self, **kwargs):  # noqa: E501
        """Get the list of email templates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smtp_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool template_status: Filter on the status of the template. Active = true, inactive = false
        :param int limit: Number of documents returned per page
        :param int offset: Index of the first document in the page
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :return: GetSmtpTemplates
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smtp_templates_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smtp_templates_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smtp_templates_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of email templates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smtp_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool template_status: Filter on the status of the template. Active = true, inactive = false
        :param int limit: Number of documents returned per page
        :param int offset: Index of the first document in the page
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :return: GetSmtpTemplates
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_status', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smtp_templates" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 1000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_smtp_templates`, must be a value less than or equal to `1000`")  # noqa: E501
        if 'limit' in params and params['limit'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_smtp_templates`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'template_status' in params:
            query_params.append(('templateStatus', params['template_status']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSmtpTemplates',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transac_blocked_contacts(self, **kwargs):  # noqa: E501
        """Get the list of blocked or unsubscribed transactional contacts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transac_blocked_contacts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str start_date: Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the blocked or unsubscribed contacts
        :param str end_date: Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the blocked or unsubscribed contacts
        :param int limit: Number of documents returned per page
        :param int offset: Index of the first document on the page
        :param list[str] senders: Comma separated list of emails of the senders from which contacts are blocked or unsubscribed
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :return: GetTransacBlockedContacts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transac_blocked_contacts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_transac_blocked_contacts_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_transac_blocked_contacts_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of blocked or unsubscribed transactional contacts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transac_blocked_contacts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str start_date: Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the blocked or unsubscribed contacts
        :param str end_date: Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the blocked or unsubscribed contacts
        :param int limit: Number of documents returned per page
        :param int offset: Index of the first document on the page
        :param list[str] senders: Comma separated list of emails of the senders from which contacts are blocked or unsubscribed
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :return: GetTransacBlockedContacts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_date', 'end_date', 'limit', 'offset', 'senders', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transac_blocked_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_transac_blocked_contacts`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in params and params['limit'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_transac_blocked_contacts`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'senders' in params:
            query_params.append(('senders', params['senders']))  # noqa: E501
            collection_formats['senders'] = 'csv'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/blockedContacts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetTransacBlockedContacts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transac_email_content(self, uuid, **kwargs):  # noqa: E501
        """Get the personalized content of a sent transactional email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transac_email_content(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Unique id of the transactional email that has been sent to a particular contact (required)
        :return: GetTransacEmailContent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transac_email_content_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_transac_email_content_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_transac_email_content_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get the personalized content of a sent transactional email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transac_email_content_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Unique id of the transactional email that has been sent to a particular contact (required)
        :return: GetTransacEmailContent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transac_email_content" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_transac_email_content`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/emails/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetTransacEmailContent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transac_emails_list(self, **kwargs):  # noqa: E501
        """Get the list of transactional emails on the basis of allowed filters  # noqa: E501

        This endpoint will show the list of emails for past 30 days by default. To retrieve emails before that time, please pass startDate and endDate in query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transac_emails_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: Mandatory if templateId and messageId are not passed in query filters. Email address to which transactional email has been sent.
        :param int template_id: Mandatory if email and messageId are not passed in query filters. Id of the template that was used to compose transactional email.
        :param str message_id: Mandatory if templateId and email are not passed in query filters. Message ID of the transactional email sent.
        :param str start_date: Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Maximum time period that can be selected is one month.
        :param str end_date: Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month.
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :param int limit: Number of documents returned per page
        :param int offset: Index of the first document in the page
        :return: GetTransacEmailsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transac_emails_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_transac_emails_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_transac_emails_list_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of transactional emails on the basis of allowed filters  # noqa: E501

        This endpoint will show the list of emails for past 30 days by default. To retrieve emails before that time, please pass startDate and endDate in query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transac_emails_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: Mandatory if templateId and messageId are not passed in query filters. Email address to which transactional email has been sent.
        :param int template_id: Mandatory if email and messageId are not passed in query filters. Id of the template that was used to compose transactional email.
        :param str message_id: Mandatory if templateId and email are not passed in query filters. Message ID of the transactional email sent.
        :param str start_date: Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Maximum time period that can be selected is one month.
        :param str end_date: Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month.
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :param int limit: Number of documents returned per page
        :param int offset: Index of the first document in the page
        :return: GetTransacEmailsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email', 'template_id', 'message_id', 'start_date', 'end_date', 'sort', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transac_emails_list" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 1000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_transac_emails_list`, must be a value less than or equal to `1000`")  # noqa: E501
        if 'limit' in params and params['limit'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_transac_emails_list`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'email' in params:
            query_params.append(('email', params['email']))  # noqa: E501
        if 'template_id' in params:
            query_params.append(('templateId', params['template_id']))  # noqa: E501
        if 'message_id' in params:
            query_params.append(('messageId', params['message_id']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/emails', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetTransacEmailsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_test_template(self, template_id, send_test_email, **kwargs):  # noqa: E501
        """Send a template to your test list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_test_template(template_id, send_test_email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: Id of the template (required)
        :param SendTestEmail send_test_email: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_test_template_with_http_info(template_id, send_test_email, **kwargs)  # noqa: E501
        else:
            (data) = self.send_test_template_with_http_info(template_id, send_test_email, **kwargs)  # noqa: E501
            return data

    def send_test_template_with_http_info(self, template_id, send_test_email, **kwargs):  # noqa: E501
        """Send a template to your test list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_test_template_with_http_info(template_id, send_test_email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: Id of the template (required)
        :param SendTestEmail send_test_email: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'send_test_email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_test_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `send_test_template`")  # noqa: E501
        # verify the required parameter 'send_test_email' is set
        if ('send_test_email' not in params or
                params['send_test_email'] is None):
            raise ValueError("Missing the required parameter `send_test_email` when calling `send_test_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'send_test_email' in params:
            body_params = params['send_test_email']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/templates/{templateId}/sendTest', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_transac_email(self, send_smtp_email, **kwargs):  # noqa: E501
        """Send a transactional email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_transac_email(send_smtp_email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SendSmtpEmail send_smtp_email: Values to send a transactional email (required)
        :return: CreateSmtpEmail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_transac_email_with_http_info(send_smtp_email, **kwargs)  # noqa: E501
        else:
            (data) = self.send_transac_email_with_http_info(send_smtp_email, **kwargs)  # noqa: E501
            return data

    def send_transac_email_with_http_info(self, send_smtp_email, **kwargs):  # noqa: E501
        """Send a transactional email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_transac_email_with_http_info(send_smtp_email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SendSmtpEmail send_smtp_email: Values to send a transactional email (required)
        :return: CreateSmtpEmail
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['send_smtp_email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_transac_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'send_smtp_email' is set
        if ('send_smtp_email' not in params or
                params['send_smtp_email'] is None):
            raise ValueError("Missing the required parameter `send_smtp_email` when calling `send_transac_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'send_smtp_email' in params:
            body_params = params['send_smtp_email']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/email', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSmtpEmail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def smtp_blocked_contacts_email_delete(self, email, **kwargs):  # noqa: E501
        """Unblock or resubscribe a transactional contact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.smtp_blocked_contacts_email_delete(email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: contact email (urlencoded) to unblock. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.smtp_blocked_contacts_email_delete_with_http_info(email, **kwargs)  # noqa: E501
        else:
            (data) = self.smtp_blocked_contacts_email_delete_with_http_info(email, **kwargs)  # noqa: E501
            return data

    def smtp_blocked_contacts_email_delete_with_http_info(self, email, **kwargs):  # noqa: E501
        """Unblock or resubscribe a transactional contact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.smtp_blocked_contacts_email_delete_with_http_info(email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: contact email (urlencoded) to unblock. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method smtp_blocked_contacts_email_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email' is set
        if ('email' not in params or
                params['email'] is None):
            raise ValueError("Missing the required parameter `email` when calling `smtp_blocked_contacts_email_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email' in params:
            path_params['email'] = params['email']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/blockedContacts/{email}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def smtp_log_message_id_delete(self, message_id, **kwargs):  # noqa: E501
        """Delete an SMTP transactional log  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.smtp_log_message_id_delete(message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str message_id: MessageId of the transactional log to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.smtp_log_message_id_delete_with_http_info(message_id, **kwargs)  # noqa: E501
        else:
            (data) = self.smtp_log_message_id_delete_with_http_info(message_id, **kwargs)  # noqa: E501
            return data

    def smtp_log_message_id_delete_with_http_info(self, message_id, **kwargs):  # noqa: E501
        """Delete an SMTP transactional log  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.smtp_log_message_id_delete_with_http_info(message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str message_id: MessageId of the transactional log to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['message_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method smtp_log_message_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params or
                params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `smtp_log_message_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'message_id' in params:
            path_params['messageId'] = params['message_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/log/{messageId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_smtp_template(self, template_id, smtp_template, **kwargs):  # noqa: E501
        """Update an email template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smtp_template(template_id, smtp_template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: id of the template (required)
        :param UpdateSmtpTemplate smtp_template: values to update in transactional email template (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_smtp_template_with_http_info(template_id, smtp_template, **kwargs)  # noqa: E501
        else:
            (data) = self.update_smtp_template_with_http_info(template_id, smtp_template, **kwargs)  # noqa: E501
            return data

    def update_smtp_template_with_http_info(self, template_id, smtp_template, **kwargs):  # noqa: E501
        """Update an email template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smtp_template_with_http_info(template_id, smtp_template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: id of the template (required)
        :param UpdateSmtpTemplate smtp_template: values to update in transactional email template (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'smtp_template']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_smtp_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_smtp_template`")  # noqa: E501
        # verify the required parameter 'smtp_template' is set
        if ('smtp_template' not in params or
                params['smtp_template'] is None):
            raise ValueError("Missing the required parameter `smtp_template` when calling `update_smtp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smtp_template' in params:
            body_params = params['smtp_template']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smtp/templates/{templateId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
