from django.shortcuts import render,redirect
from .forms import *
from django.contrib.auth import login, logout
from django.contrib.auth.forms import AuthenticationForm
from django.contrib.auth import login, authenticate
from django.contrib.auth.models import User, Group
from django.contrib.auth.decorators import login_required


# Create your views here.
def index(request):
    count = Counter.objects.all()[0].counter
    if(count >= 1):
        if(not request.user.is_authenticated):
            return redirect('login')
        flag = 0
        name = ""
        used_obj = Member.objects.filter(user=request.user)[0]
        category = used_obj.user_type.name
        state=""
        state_id=""
        try:
            state = State.objects.filter(name=used_obj.state)[0]
            print(state)
            state_id = state.id
        except:
            pass
    
        district=""
        city = ""
        mandal= ""
        try:
            district = used_obj.district.id
        except:
            pass
        try:
            city = used_obj.city.id
        except:
            pass
        try:
            mandal = used_obj.mandal.id
        except:
            pass
        if(category == 'Administrator'):
            flag = 1
        elif(category == 'State Coordinator'):
            flag = 2
        elif(category == 'District Coordinator'):
            flag = 3
        elif(category == 'Mandal Coordinator'):
            flag = 0
        elif(category == 'City Coordinator'):
            flag = 4
        name = used_obj.name
        context = {
            'flag':flag,
            'name':name,
            'state':state_id,
            'district':district,
            'city':city,
            'mandal':mandal,
        }
        return render(request,'index.html',context=context)
    else:
        return render(request,'index2.html')

def inaugurated(request):
    counter_obj = Counter.objects.all()[0]
    counter_obj.counter=1
    counter_obj.save()
    if(not request.user.is_authenticated):
            return redirect('login')
    flag = 0
    name = ""
    used_obj = Member.objects.filter(user=request.user)[0]
    category = used_obj.user_type.name
    state=""
    state_id=""
    try:
        state = State.objects.filter(name=used_obj.state)[0]
        print(state)
        state_id = state.id
    except:
        pass

    district=""
    city = ""
    mandal= ""
    try:
        district = used_obj.district.id
    except:
        pass
    try:
        city = used_obj.city.id
    except:
        pass
    try:
        mandal = used_obj.mandal.id
    except:
        pass
    if(category == 'Administrator'):
        flag = 1
    elif(category == 'State Coordinator'):
        flag = 2
    elif(category == 'District Coordinator'):
        flag = 3
    elif(category == 'Mandal Coordinator'):
        flag = 0
    elif(category == 'City Coordinator'):
        flag = 4
    name = used_obj.name
    context = {
        'flag':flag,
        'name':name,
        'state':state_id,
        'district':district,
        'city':city,
        'mandal':mandal,
    }
    return render(request,'index.html',context=context)


def signin(request):
    if request.method == "POST":
        form = AuthenticationForm(request, data=request.POST)
        if form.is_valid():
            username = form.cleaned_data.get('username')
            password = form.cleaned_data.get('password')
            user = authenticate(username=username, password=password)
            if user is not None:
                login(request, user)
                return redirect("index")
            else:
                pass
        else:
            pass
    form = AuthenticationForm()
    return render(request,'login.html',context={"login_form": form})

def signout(request):
    logout(request)
    return redirect('login')

def ExpertsPage(request):
    if request.method == 'POST':
        form = ExpertsForm(request.POST,request.FILES)
        if form.is_valid():
            # Create a new Product instance with form data
            new_product = Experts(
                name=form.cleaned_data['name'],
                email=form.cleaned_data['email'],
                keywords=form.cleaned_data['keywords'],
                educational_qualification=form.cleaned_data['educational_qualification'],
                designation=form.cleaned_data['designation'],
                gender=form.cleaned_data['gender'],
                workplace=form.cleaned_data['workplace'],
                address_of_correspondence=form.cleaned_data['address_of_correspondence'],
                permanent_address=form.cleaned_data['permanent_address'],
                mobile_number=form.cleaned_data['mobile_number'],
                important_document = request.FILES['important_document'],
            )
            new_product.save()
            return redirect('index')  # Redirect to a success page or another view
    else:
        form = ExpertsForm()

    return render(request, 'experts.html', {'form': form})

def MeetingMinutesPage(request,mandal_id):
    try:
        mandal = Mandal.objects.filter(id=mandal_id)[0]
    except:
        mandal = Mandal.objects.filter(name=mandal_id)[0]
    city = City.objects.filter(id=mandal.city.id)[0]
    district = District.objects.filter(id=city.district.id)[0]
    state = State.objects.filter(id=district.state.id)[0]
    if request.method == 'POST':
        form = MeetingMinutesForm(request.POST or None,request.FILES, mandal=mandal)
        # print(request.FILES)
        if form.is_valid():
            members_attended_id = request.POST.getlist('members_attended')
            # Create a new Product instance with form data

            new_product = meeting_minutes(
                category=form.cleaned_data['category'],
                state = state,
                district = district,
                city = city,
                mandal = mandal,
                title=form.cleaned_data['title'],
                expert=form.cleaned_data['expert'],
                meeting_date=form.cleaned_data['meeting_date'],
                meeting_time=form.cleaned_data['meeting_time'],
                meeting_minutes=form.cleaned_data['meeting_minutes'],
                upload_document=request.FILES['upload_document'],
            )
            new_product.save()
            new_product.members_attended.set(members_attended_id)
            new_product.save()
            return redirect('index')  # Redirect to a success page or another view
    else:
        form = MeetingMinutesForm(request.POST or None, mandal=mandal)

    return render(request, 'meetings.html', {'form': form})

def member_register_page(request,flag):
    district = ""
    state = ""
    city = ""
    if(flag == "1"):
        title = "Add State Coordinators"
        desc = "Please add state coordinators here carefully."
        form = StateCoordinatorRegistrationForm()
    elif(flag == "2"):
        title = "Add District Coordinators"
        desc = "Please add district coordinators here carefully."
        state = Member.objects.filter(user=request.user)[0].state
        state_obj = State.objects.filter(name=state)[0]
        form = DistrictCoordinatorForm(state=state_obj)
    elif(flag == "3"):
        title = "Add City Coordinators"
        desc = "Please add city coordinators here carefully."
        state = Member.objects.filter(user=request.user)[0].state
        state_obj = State.objects.filter(name=state)[0]
        district = Member.objects.filter(user=request.user)[0].district
        district_obj = District.objects.filter(name=district)[0]
        form = CityCoordinatorForm(district=district_obj)
    elif(flag == "4"):
        title = "Add Mandal Coordinators"
        desc = "Please add mandal coordinators here carefully."
        state = Member.objects.filter(user=request.user)[0].state
        state_obj = State.objects.filter(name=state)[0]
        district = Member.objects.filter(user=request.user)[0].district
        district_obj = District.objects.filter(name=district)[0]
        city_obj = Member.objects.filter(user=request.user)[0].city
        form = MandalCoordinatorForm(city=city_obj)
    elif(flag == "0"):
        title = "Add Mandal Members"
        desc = "Please add mandal members here carefully."
        state = Member.objects.filter(user=request.user)[0].state
        state_obj = State.objects.filter(name=state)[0]
        district = Member.objects.filter(user=request.user)[0].district
        district_obj = District.objects.filter(name=district)[0]
        city_obj = Member.objects.filter(user=request.user)[0].city
        mandal_obj = Member.objects.filter(user=request.user)[0].mandal
        form = MembershipForm()
    elif(flag == "7"):
        title = "Add Experts"
        desc = "Please add experts here carefully."
        form = ExpertsForm()
    if request.method == 'POST':
        if(flag == "1"):
            form = StateCoordinatorRegistrationForm(request.POST)
            if form.is_valid():
                # Create a new Product instance with form data
                state = form.cleaned_data['state']
                title = form.cleaned_data['title']
                name = form.cleaned_data['name']
                email = form.cleaned_data['email']
                mail = form.cleaned_data['mail']
                password = form.cleaned_data['password']
                user = User.objects.create_user(username=email,email=mail, password=password)
                group_names = ['Member']  # Replace with your group names
                for group_name in group_names:
                    group, created = Group.objects.get_or_create(name=group_name)
                    user.groups.add(group)
                user.is_staff = True
                user.save()
                user_type_obj = UserCategory.objects.filter(name="State Coordinator")[0]
                member_obj = Member(user=user,name=name,state=state,user_type=user_type_obj)
                member_obj.save()
                return redirect('state_coordinators')  # Redirect to a success page or another view
        elif(flag == '2'):
            form = DistrictCoordinatorForm(request.POST)
            if form.is_valid():
                # Create a new Product instance with form data
                state_name = Member.objects.filter(user=request.user)[0].state
                state_obj = State.objects.filter(name=state_name)[0]
                state = state_obj
                district = form.cleaned_data['district']
                title = form.cleaned_data['title']
                name = form.cleaned_data['name']
                email = form.cleaned_data['email']
                mail = form.cleaned_data['mail']
                password = form.cleaned_data['password']
                user = User.objects.create_user(username=email,email=mail, password=password)
                group_names = ['Member']  # Replace with your group names
                for group_name in group_names:
                    group, created = Group.objects.get_or_create(name=group_name)
                    user.groups.add(group)
                user.is_staff = True
                user.save()
                user_type_obj = UserCategory.objects.filter(name="District Coordinator")[0]
                district_obj = District.objects.filter(name=district)[0]
                member_obj = Member(user=user,name=title + ' ' +name,state=state,user_type=user_type_obj,district=district_obj)
                member_obj.save()
                return redirect('district_coordinators',state_obj)  # Redirect to a success page or another view
        elif(flag == '3'):
            form = CityCoordinatorForm(request.POST)
            if form.is_valid():
                # Create a new Product instance with form data
                state_name = Member.objects.filter(user=request.user)[0].state
                state_obj = State.objects.filter(name=state_name)[0]
                state = state_obj
                city = form.cleaned_data['city']
                title = form.cleaned_data['title']
                name = form.cleaned_data['name']
                email = form.cleaned_data['email']
                mail = form.cleaned_data['mail']
                password = form.cleaned_data['password']
                user = User.objects.create_user(username=email,email=mail, password=password)
                group_names = ['Member']  # Replace with your group names
                for group_name in group_names:
                    group, created = Group.objects.get_or_create(name=group_name)
                    user.groups.add(group)
                user.is_staff = True
                user.save()
                user_type_obj = UserCategory.objects.filter(name="City Coordinator")[0]
                district_id = Member.objects.filter(user=request.user)[0].district.id
                district_obj = District.objects.get(id=district_id)
                city_obj = city
                member_obj = Member(user=user,name=title + ' ' +name,state=state,user_type=user_type_obj,district=district_obj,city=city_obj)
                member_obj.save()
                return redirect('city_coordinators',state_obj.id,district_obj.id)  # Redirect to a success page or another view
        elif(flag == '4'):
            form = MandalCoordinatorForm(request.POST)
            if form.is_valid():
                # Create a new Product instance with form data
                state_name = Member.objects.filter(user=request.user)[0].state
                state_obj = State.objects.filter(name=state_name)[0]
                state = state_obj
                city = Member.objects.filter(user=request.user)[0].city
                mandal = form.cleaned_data['mandal']
                title = form.cleaned_data['title']
                name = form.cleaned_data['name']
                email = form.cleaned_data['email']
                mail = form.cleaned_data['mail']
                password = form.cleaned_data['password']
                user = User.objects.create_user(username=email,email=mail, password=password)
                group_names = ['Member']  # Replace with your group names
                for group_name in group_names:
                    group, created = Group.objects.get_or_create(name=group_name)
                    user.groups.add(group)
                user.is_staff = True
                user.save()
                user_type_obj = UserCategory.objects.filter(name="Mandal Coordinator")[0]
                district_obj = Member.objects.filter(user=request.user)[0].district
                district_fin = District.objects.filter(name=district_obj)[0]
                city_obj = city
                mandal_obj = mandal
                member_obj = Member(user=user,name=title + ' ' +name,state=state,user_type=user_type_obj,district=district_fin,city=city_obj,mandal=mandal)
                member_obj.save()
                return redirect('mandal_coordinators',state_obj.id,district_obj.id,city_obj.id)
        elif(flag == '0'):
            form = MembershipForm(request.POST,request.FILES)
            if form.is_valid():
                # Create a new Product instance with form data
                state_name = Member.objects.filter(user=request.user)[0].state
                state_obj = State.objects.filter(name=state_name)[0]
                state = state_obj
                city = Member.objects.filter(user=request.user)[0].city
                mandal = Member.objects.filter(user=request.user)[0].mandal
                name = form.cleaned_data['name']
                educational_qualification = form.cleaned_data['educational_qualification']
                specialization = form.cleaned_data['specialization']
                designation = form.cleaned_data['designation']
                gender = form.cleaned_data['gender']
                workplace = form.cleaned_data['workplace']
                membership_id = form.cleaned_data['membership_id']
                address_of_correspondence = form.cleaned_data['address_of_correspondence']
                permanent_address = form.cleaned_data['permanent_address']
                mobile_number = form.cleaned_data['mobile_number']
                upload_photo = request.FILES['upload_photo']
                upload_file = request.FILES['upload_file']
                user_type_obj = UserCategory.objects.filter(name="Mandal Member")[0]
                district_obj = Member.objects.filter(user=request.user)[0].district
                city_obj = Member.objects.filter(user=request.user)[0].city
                mandal_obj = Member.objects.filter(user=request.user)[0].mandal
                email = Member.objects.filter(user=request.user)[0].email
                user = User.objects.create_user(username=f'{name}{mandal_obj.id}@bsm.org', password=f'{name}{mandal_obj.id}@bsm.org',email=email)
                group_names = ['Member']  # Replace with your group names
                for group_name in group_names:
                    group, created = Group.objects.get_or_create(name=group_name)
                    user.groups.add(group)
                user.is_staff = True
                user.save()
                member_obj = Member(user=user,
                                    name=name,
                                    state=state,
                                    user_type=user_type_obj,
                                    district=district_obj,
                                    city=city_obj,
                                    mandal=mandal_obj,
                                    educational_qualification=educational_qualification,
                                    specialization=specialization,
                                    designation=designation,
                                    gender=gender,
                                    workplace=workplace,
                                    membership_id=membership_id,
                                    address_of_correspondence=address_of_correspondence,
                                    permanent_address = permanent_address,
                                    mobile_number = mobile_number,
                                    upload_photo=upload_photo,
                                    upload_file=upload_file,
                                    )
                member_obj.save()
               
                return redirect('members_list_mandal',mandal_obj.id)
        elif(flag == '7'):
            form = ExpertsForm(request.POST,request.FILES)
            if form.is_valid():
                meeting = form.save()
                return redirect('index')
            else:
                print(form.errors)
        else:
            state_name = Member.objects.filter(user=request.user)[0].state
            state_obj = State.objects.filter(name=state_name)[0]
            form = DistrictCoordinatorForm(state=state_obj)
    city = Member.objects.filter(user=request.user)[0].city
    mandal = Member.objects.filter(user=request.user)[0].mandal
    context = {
            "title":title,
            "desc":desc,
            'form': form,
            'state':state,
            'district':district,
            'city':city,
            'mandal':mandal,
        }
    return render(request, 'experts.html', context=context)

def list_districts(request,state_id):
    state = State.objects.filter(id=state_id)[0]
    districts_list = District.objects.filter(state=state)

    context = {
            "state_id":state.id,
            "districts_list":districts_list,
        }
    return render(request, 'add_districts.html', context=context)

def list_city(request,state_id,district_id):
    try:    
        state = State.objects.filter(id=state_id)[0]
    except:
        state = State.objects.filter(name=state_id)[0]
    try:
        district = District.objects.filter(id=district_id)[0]
    except:
        district = District.objects.filter(name=district_id)[0]
    mandal_list = City.objects.filter(district=district)

    context = {
            "state_id":state.id,
            "mandal_list":mandal_list,
            "district":district,
            "state":state,
        }
    return render(request, 'add_mandal.html', context=context)

def list_mandal(request,state_id,district_id,city_id):
    state = State.objects.filter(id=state_id)[0]
    try:
        district = District.objects.filter(id=district_id)[0]
    except:
        district = District.objects.filter(name=district_id)[0]
    try:
        city = City.objects.filter(id=city_id)[0]
    except:
        city = City.objects.filter(name=city_id)[0]
    mandal_list = Mandal.objects.filter(city=city)

    context = {
            "state_id":state.id,
            "mandal_list":mandal_list,
            "district":district,
            "state":state,
            "city":city,
        }
    return render(request, 'add_city.html', context=context)


def add_districts(request,state_id):
    state = State.objects.filter(id=state_id)[0]
    title = "Add New Districts"
    desc = f"Please add new Districts here carefully for the { state.name } state."
    form = DistrictForm()
    if request.method == 'POST':
        form = DistrictForm(request.POST)
        if form.is_valid():
            # Create a new Product instance with form data
            new_product = District(
                name=form.cleaned_data['name'],
                state = state,
            )
            new_product.save()
            return redirect('add_districts',state_id)  # Redirect to a success page or another view
    else:
        form = DistrictForm()

    context = {
            "title":title,
            "desc":desc,
            'form': form,
            'state':state,
        }
    return render(request, 'experts.html', context=context)

def add_city(request,state_id,district_id):
    state = State.objects.filter(id=state_id)[0]
    try:
        district = District.objects.filter(id=district_id)[0]
    except:
        district = District.objects.filter(name=district_id)[0]
    title = "Add New City"
    desc = f"Please add new city here carefully for the { state.name } state and { district.name } district."
    form = MandalForm()
    if request.method == 'POST':
        form = MandalForm(request.POST)
        if form.is_valid():
            # Create a new Product instance with form data
            new_product = City(
                name=form.cleaned_data['name'],
                district = district,
            )
            new_product.save()
            return redirect('add_city',state_id,district_id)  # Redirect to a success page or another view
    else:
        form = MandalForm()

    context = {
            "title":title,
            "desc":desc,
            'form': form,
            'state':state,
            'district':district,
        }
    return render(request, 'experts.html', context=context)

def add_mandal(request,state_id,district_id,city_id):
    state = State.objects.filter(id=state_id)[0]
    try:
        district = District.objects.filter(id=district_id)[0]
    except:
        district = District.objects.filter(name=district_id)[0]
    try:
        city = City.objects.filter(id=city_id)[0]
    except:
        city = City.objects.filter(name=city_id)[0]
    title = "Add New Mandal"
    desc = f"Please add new mandal here carefully for the { state.name } state, { district.name } district and { city.name } city."
    form = CityForm()
    if request.method == 'POST':
        form = CityForm(request.POST)
        if form.is_valid():
            # Create a new Product instance with form data
            new_product = Mandal(
                name=form.cleaned_data['name'],
                city = city,
            )
            new_product.save()
            return redirect('add_mandal',state_id,district_id,city_id)  # Redirect to a success page or another view
    else:
        form = CityForm()
    print(city)
    context = {
            "title":title,
            "desc":desc,
            'form': form,
            'state':state,
            'district':district,
            'city':city,
        }
    return render(request, 'experts.html', context=context)

def register_request(request,mandal_id):
    mandal = Mandal.objects.get(id=mandal_id)
    city = mandal.city
    district = city.district
    state = district.state

    if request.method == "POST":
        form = NewUserForm(request.POST)
        if form.is_valid():
            user = form.save()
            # login(request, user)
            member_object = Member(user=user,name=user.username.split('@')[0],mandal=mandal,user_type_id=5,state=state,district=district,city=city)
            member_object.save()
            return redirect("members_list_mandal",mandal_id=mandal_id)
        else:
            return render(request=request,
                          template_name="register_mandal.html",
                          context={"form": form})
    form = NewUserForm()
    return render(request=request,
                  template_name="register_mandal.html",
                  context={"form": form})

def view_mandal_members(request,mandal_id):
    mandal = Mandal.objects.get(id=mandal_id)
    members_list = Member.objects.filter(mandal=mandal)
    return render(request=request,
                  template_name="view_mandal_members.html",
                  context={"members_list": members_list,"mandal":mandal,"mandal_id":mandal_id,"flag":0})

def view_state_coordinator(request):
    user_type_obj = UserCategory.objects.filter(name="State Coordinator")[0]
    members_list = Member.objects.filter(user_type=user_type_obj)
    return render(request=request,
                  template_name="view_mandal_members.html",
                  context={"members_list": members_list,"flag":1})

def view_district_coordinator(request,state_id):
    try:
        state = State.objects.filter(id=state_id)[0]
    except:
        state = State.objects.filter(name=state_id)[0]
    user_type_obj = UserCategory.objects.filter(name="District Coordinator")[0]
    members_list = Member.objects.filter(user_type=user_type_obj,state=state)
    return render(request=request,
                  template_name="view_district_coordinators.html",
                  context={"members_list": members_list,"flag":1})

def view_city_coordinator(request,state_id,district_id):
    state = State.objects.filter(id=state_id)[0]
    try:
        district = District.objects.filter(id=district_id)[0]
    except:
        district = District.objects.filter(name=district_id)[0]
    user_type_obj = UserCategory.objects.filter(name="City Coordinator")[0]
    members_list = Member.objects.filter(user_type=user_type_obj,state=state)
    return render(request=request,
                  template_name="view_city_coordinators.html",
                  context={"members_list": members_list,"flag":1})

def view_mandal_coordinators(request,state_id,district_id,city_id):
    state = State.objects.filter(id=state_id)[0]
    try:
        district = District.objects.filter(id=district_id)[0]
    except:
        district = District.objects.filter(name=district_id)[0]
    try:
        city = City.objects.filter(id=city_id)[0]
    except:
        city = City.objects.filter(name=city_id)[0] 
    user_type_obj = UserCategory.objects.filter(name="Mandal Coordinator")[0]
    members_list = Member.objects.filter(user_type=user_type_obj,city=city)
    return render(request=request,
                  template_name="view_mandal_coordinators.html",
                  context={"members_list": members_list,"flag":1})

def delete_member(request, member_id,mandal_id):
    member = Member.objects.get(id=member_id)
    username = member.user.username
    user = User.objects.get(username=username)
    user.delete()
    return redirect("members_list_mandal",mandal_id=mandal_id)

def search_people(request):
    member = Member.objects.all()
    return render(request=request,
                  template_name="search_people.html",
                  context={"members_list": member})

def meeting_details(request,state_id):
    state = State.objects.filter(id=state_id)[0]
    meeting_list = meeting_minutes.objects.filter(state=state)
    return render(request=request,
                    template_name="meeting_details.html",
                    context={"meeting_list": meeting_list,"state":state.name})


def meeting_details_district(request,state_id,district_id):
    state = State.objects.filter(id=state_id)[0]
    try:
        district = District.objects.filter(id=district_id)[0]
    except:
        district = District.objects.filter(name=district_id)[0]
    meeting_list = meeting_minutes.objects.filter(state=state,district=district)
    return render(request=request,
                    template_name="meeting_details.html",
                    context={"meeting_list": meeting_list,"state":state.name,"district":district})

def meeting_details_city(request,state_id,district_id,city_id):
    state = State.objects.filter(id=state_id)[0]
    try:
        district = District.objects.filter(id=district_id)[0]
    except:
        district = District.objects.filter(name=district_id)[0]
    try:
        city = City.objects.filter(id=city_id)[0]
    except:
        city = City.objects.filter(name=city_id)[0]
    meeting_list = meeting_minutes.objects.filter(state=state,district=district,city=city)
    return render(request=request,
                    template_name="meeting_details.html",
                    context={"meeting_list": meeting_list,"state":state.name,"district":district,"city":city})

@login_required
def change_password(request):
    form = ChangePasswordForm()
    if request.method == 'POST':
        form = ChangePasswordForm(request.POST)
        if form.is_valid():
            old_password = form.cleaned_data['old_password']
            new_password1 = form.cleaned_data['new_password1']
            new_password2 = form.cleaned_data['new_password2']

            user = request.user  # Get the current user

            # Authenticate the user with the old password
            if user.check_password(old_password):
                # Check if the new passwords match
                if new_password1 == new_password2:
                    # Set the new password and save the user
                    user.set_password(new_password1)
                    user.save()

                    # Log the user in with the new password
                    login(request, user)

                    return render(request, 'password_changed.html',{'flag':1})  # Redirect to a success page
                else:
                    return render(request, 'password_changed.html', {'error_message': 'New passwords do not match','form':form})
            else:
                return render(request, 'password_changed.html', {'error_message': 'Old password is incorrect','form':form})
    else:
        form = ChangePasswordForm()

    return render(request, 'password_changed.html', {'form': form})
