from django.conf import settings
from django.urls import path
from django.conf.urls.static import static
from .views import *

urlpatterns = [
    path("", index, name="index"),
    path("inaugurated",inaugurated,name="inaugurated"),
    path("change_password",change_password,name="change_password"),
    path('login',signin,name="login"),
    path('signout',signout,name="signout"),
    path('register_member/<flag>/',member_register_page,name="experts"),
    path('meeting_minutes/<mandal_id>/',MeetingMinutesPage,name="minutes"),
    path('register/<mandal_id>',register_request,name="register"),
    path('mandal_members_list/<mandal_id>',view_mandal_members,name="members_list_mandal"),
    path('delete_member/<mandal_id>/<member_id>',delete_member,name="delete_member"),
    path('people',search_people,name="search_people"),
    path('state_coordinators',view_state_coordinator,name="state_coordinators"),
    path('district_coordinators/<state_id>/',view_district_coordinator,name="district_coordinators"),
    path('city_coordinators/<state_id>/<district_id>/',view_city_coordinator,name="city_coordinators"),
    path('mandal_coordinators/<state_id>/<district_id>/<city_id>/',view_mandal_coordinators,name="mandal_coordinators"),
    path('list_districts/<state_id>/',list_districts,name="add_districts"),
    path('list_cities/<state_id>/<district_id>/',list_city,name="add_city"),
    path('list_mandal/<state_id>/<district_id>/<city_id>/',list_mandal,name="add_mandal"),
    path('add_districts/<state_id>/',add_districts,name="add_new_district"),
    path('add_city/<state_id>/<district_id>/',add_city,name="add_new_city"),
    path('add_mandal/<state_id>/<district_id>/<city_id>/',add_mandal,name="add_new_mandal"),
    path('meeting_details/<state_id>/',meeting_details,name="meeting_details"),
    path('meeting_details/<state_id>/<district_id>/',meeting_details_district,name="meeting_details_district"),
    path('meeting_details/<state_id>/<district_id>/<city_id>/',meeting_details_city,name="meeting_details_city"),
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)