from django.db import models
from django.contrib.auth.models import User

# Create your models here.
class State(models.Model):
    name = models.CharField(max_length=200)

    def __str__(self):
        return self.name
    
    class Meta:
        verbose_name_plural = "States"

class District(models.Model):
    state = models.ForeignKey(State,on_delete = models.CASCADE)
    name = models.CharField(max_length=200)

    def __str__(self):
        return self.name
    
    class Meta:
        verbose_name_plural = "Districts"

class City(models.Model):
    district = models.ForeignKey(District,on_delete = models.CASCADE)
    name = models.CharField(max_length=200)

    def __str__(self):
        return self.name
    
    class Meta:
        verbose_name_plural = "Cities"

class Mandal(models.Model):
    city = models.ForeignKey(City,on_delete = models.CASCADE)
    name = models.CharField(max_length=200)
    approved = models.BooleanField(default=False)

    def __str__(self):
        return self.name
    
    class Meta:
        verbose_name_plural = "Mandals"

MALE = 'M'
FEMALE = 'F'
OTHER = 'O'

GENDER_CHOICES = [
    (MALE, 'Male'),
    (FEMALE, 'Female'),
    (OTHER, 'Other'),
]

class UserCategory(models.Model):
    name = models.CharField(max_length=250,default=" ")

    def __str__(self):
        return self.name
    
    class Meta:
        verbose_name_plural = "User Category"

class Member(models.Model):
    user = models.ForeignKey('auth.User',on_delete=models.CASCADE)
    name = models.CharField(max_length=300)
    email = models.EmailField(max_length=200,blank=True,null=True)
    state = models.ForeignKey(State,on_delete = models.CASCADE,blank=True,null=True)
    district = models.ForeignKey(District,on_delete = models.CASCADE,blank=True,null=True)
    city = models.ForeignKey(City,on_delete = models.CASCADE,blank=True,null=True)
    mandal = models.ForeignKey(Mandal,on_delete = models.CASCADE,blank=True,null=True)
    educational_qualification = models.CharField(max_length=1000,blank=True,null=True,help_text="Please put the highest qualification here")
    specialization = models.CharField(max_length=1000)
    designation = models.CharField(max_length=250,blank=True,null=True)
    gender = models.CharField(max_length=1, choices=GENDER_CHOICES)
    workplace = models.CharField(max_length=250,blank=True,null=True)
    membership_id = models.CharField(max_length=250,blank=True,null=True)
    address_of_correspondence = models.TextField(blank=True,null=True)
    permanent_address = models.TextField(blank=True,null=True)
    mobile_number = models.CharField(max_length=250,blank=True,null=True)
    upload_photo = models.FileField(upload_to='member-photo/%Y/',blank=True,null=True)
    upload_file = models.FileField(upload_to='member-document/%Y/',blank=True,null=True)
    user_type = models.ForeignKey(UserCategory, on_delete=models.CASCADE,blank=True, null=True)

    def __str__(self):
        return self.name
    
    class Meta:
        verbose_name_plural = "Members"

class meeting_categories(models.Model):
    name = models.CharField(max_length=400)

    def __str__(self):
        return self.name
    
    class Meta:
        verbose_name_plural = "Meeting Categories"

class Experts(models.Model):
    name = models.CharField(max_length=300)
    email = models.EmailField(max_length=200)
    mobile_number = models.CharField(max_length=300,blank=True,null=True)
    keywords = models.CharField(max_length=300)
    educational_qualification = models.CharField(max_length=300,blank=True,null=True)
    designation = models.CharField(max_length=300,blank=True,null=True)
    gender = models.CharField(max_length=1, choices=GENDER_CHOICES)
    workplace = models.CharField(max_length=300,blank=True,null=True)
    address_of_correspondence = models.TextField(blank=True,null=True)
    permanent_address = models.TextField(blank=True,null=True)
    important_document = models.FileField(upload_to='experts-document/%Y/',blank=True,null=True)

    def __str__(self):
        return self.name
    
    class Meta:
        verbose_name_plural = "Experts"

class meeting_minutes(models.Model):
    category = models.ForeignKey(meeting_categories,on_delete=models.CASCADE)
    state = models.ForeignKey(State,on_delete = models.CASCADE,blank=True,null=True)
    district = models.ForeignKey(District,on_delete = models.CASCADE,blank=True,null=True)
    city = models.ForeignKey(City,on_delete = models.CASCADE,blank=True,null=True)
    mandal = models.ForeignKey(Mandal,on_delete = models.CASCADE,blank=True,null=True)
    title = models.CharField(max_length=200,help_text="Please add the title of the meeting here, for example : 'राष्ट्रीय शिक्षा नीति'")
    expert = models.ForeignKey(Experts,on_delete=models.CASCADE)
    meeting_date = models.DateField()
    meeting_time = models.TimeField()
    meeting_minutes = models.TextField(help_text="Please explain the the meeting minutes briefly")
    members_attended = models.ManyToManyField(Member)
    upload_document = models.FileField(upload_to='uploads/%Y/%m/%d/', null=True, blank=True)

    def __str__(self):
        return self.title
    
    class Meta:
        verbose_name_plural = "Meeting Minutes"

class PasswordMapping(models.Model):
    member = models.ForeignKey(Member,on_delete=models.CASCADE)
    username = models.CharField(max_length=300,help_text="Username should be unique")
    password = models.CharField(max_length=200,help_text="Please enter password for the user")
    confirm_password = models.CharField(max_length=200,help_text="Please confirm password for the user")

    def __str__(self):
        return self.username
    
    class Meta:
        verbose_name_plural = "Password Mapping"

class Counter(models.Model):
    counter = models.IntegerField(default=0)

    def __str__(self):
        return str(self.counter)
    
    class Meta:
        verbose_name_plural = "Counter"
