# Generated by Django 4.1.4 on 2024-01-06 09:03

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="City",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=200)),
            ],
            options={
                "verbose_name_plural": "Cities",
            },
        ),
        migrations.CreateModel(
            name="District",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=200)),
            ],
            options={
                "verbose_name_plural": "Districts",
            },
        ),
        migrations.CreateModel(
            name="Experts",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=300)),
                ("email", models.EmailField(max_length=200)),
                ("keywords", models.TextField(max_length=300)),
                ("educational_qualification", models.TextField(blank=True, null=True)),
                ("designation", models.TextField(blank=True, null=True)),
                (
                    "gender",
                    models.CharField(
                        choices=[("M", "Male"), ("F", "Female"), ("O", "Other")],
                        max_length=1,
                    ),
                ),
                ("workplace", models.TextField(blank=True, null=True)),
                ("address_of_correspondence", models.TextField(blank=True, null=True)),
                ("permanent_address", models.TextField(blank=True, null=True)),
                ("mobile_number", models.TextField(blank=True, null=True)),
            ],
            options={
                "verbose_name_plural": "Experts",
            },
        ),
        migrations.CreateModel(
            name="Mandal",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=200)),
                ("approved", models.BooleanField(default=False)),
                (
                    "city",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mandal_app.city",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Mandals",
            },
        ),
        migrations.CreateModel(
            name="meeting_categories",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=400)),
            ],
            options={
                "verbose_name_plural": "Members",
            },
        ),
        migrations.CreateModel(
            name="State",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=200)),
            ],
            options={
                "verbose_name_plural": "States",
            },
        ),
        migrations.CreateModel(
            name="Member",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=300)),
                ("email", models.EmailField(max_length=200)),
                ("password", models.CharField(max_length=200)),
                ("confirm_password", models.CharField(max_length=200)),
                ("educational_qualification", models.TextField(blank=True, null=True)),
                ("designation", models.TextField(blank=True, null=True)),
                (
                    "gender",
                    models.CharField(
                        choices=[("M", "Male"), ("F", "Female"), ("O", "Other")],
                        max_length=1,
                    ),
                ),
                ("workplace", models.TextField(blank=True, null=True)),
                ("membership_id", models.TextField(blank=True, null=True)),
                ("address_of_correspondence", models.TextField(blank=True, null=True)),
                ("permanent_address", models.TextField(blank=True, null=True)),
                ("mobile_number", models.TextField(blank=True, null=True)),
                ("upload_photo", models.FileField(upload_to="")),
                ("user_type_id", models.IntegerField(default=0)),
                (
                    "city",
                    models.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mandal_app.city",
                    ),
                ),
                (
                    "district",
                    models.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mandal_app.district",
                    ),
                ),
                (
                    "mandal",
                    models.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mandal_app.mandal",
                    ),
                ),
                (
                    "state",
                    models.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mandal_app.state",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Members",
            },
        ),
        migrations.CreateModel(
            name="meeting_minutes",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=200)),
                ("meeting_date", models.DateField()),
                ("meeting_time", models.TimeField()),
                ("meeting_minutes", models.TextField()),
                ("members_attended", models.TextField()),
                ("upload_document", models.FileField(upload_to="")),
                (
                    "category",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mandal_app.meeting_categories",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Meeting Minutes",
            },
        ),
        migrations.AddField(
            model_name="district",
            name="state",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="mandal_app.state"
            ),
        ),
        migrations.AddField(
            model_name="city",
            name="district",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="mandal_app.district"
            ),
        ),
    ]
