from django import forms
from django.contrib.auth.forms import UserCreationForm
from django.contrib.auth.models import User
from django.core.exceptions import ValidationError
from .models import *

class ChangePasswordForm(forms.Form):
    old_password = forms.CharField(widget=forms.PasswordInput)
    new_password1 = forms.CharField(widget=forms.PasswordInput)
    new_password2 = forms.CharField(widget=forms.PasswordInput)


class DateInput(forms.DateInput):
    input_type = 'date'

class ExpertsForm(forms.ModelForm):
     class Meta:
        model = Experts
        fields = '__all__'

class MeetingMinutesForm(forms.ModelForm):
    class Meta:
        model = meeting_minutes
        fields = ("category",'title','expert','meeting_date','meeting_time','meeting_minutes','members_attended','upload_document')
        widgets = {
            'meeting_date': forms.DateInput(attrs={'type': 'date'}),
            'meeting_time': forms.TimeInput(attrs={'type': 'time'}),
        }
    
    members_attended = forms.ModelMultipleChoiceField(queryset=Member.objects.all(), widget=forms.CheckboxSelectMultiple)
    
    def __init__(self, *args, **kwargs):
        mandal = kwargs.pop('mandal', None)  # Get the genre parameter
        super().__init__(*args, **kwargs)

        # Optionally, filter authors based on the provided genre
        if mandal:
            self.fields['members_attended'].queryset = Member.objects.filter(mandal=mandal).distinct()

class NewUserForm(UserCreationForm):
    # email = forms.EmailField(required=True)

    class Meta:
        model = User
        fields = ("username", "password1", "password2")

    def save(self, commit=True):
        user = super(NewUserForm, self).save(commit=False)
        if commit:
            user.save()
        return user

class StateCoordinatorRegistrationForm(forms.Form):
    state = forms.ModelChoiceField(
        queryset=State.objects.all(),
        empty_label='Select State',
        label='State'
    )

    TITLE_CHOICES = [
        ('SHRI', 'Shri'),
        ('SMT', 'Smt.'),
        ('DR', 'Dr.'),
        ('PROF', 'Prof.'),
    ]

    title = forms.ChoiceField(choices=TITLE_CHOICES, label='Title')
    name = forms.CharField(label='Name')
    email = forms.CharField(label='User Name')
    mail = forms.EmailField(label='E-mail Address')
    password = forms.CharField(widget=forms.PasswordInput, label='Password')
    confirm_password = forms.CharField(widget=forms.PasswordInput, label='Confirm Password')

    def clean(self):
        cleaned_data = super().clean()
        password = cleaned_data.get('password')
        confirm_password = cleaned_data.get('confirm_password')

        if password and confirm_password and password != confirm_password:
            raise forms.ValidationError("Passwords do not match.")

        return cleaned_data

class DistrictCoordinatorForm(forms.Form):
    TITLE_CHOICES = [
        ('SHRI', 'Shri'),
        ('SMT', 'Smt.'),
        ('DR', 'Dr.'),
        ('PROF', 'Prof.'),
    ]
    district = forms.ModelChoiceField(queryset=District.objects.all(), label='District')
    title = forms.ChoiceField(choices=TITLE_CHOICES, label='Title')
    name = forms.CharField(label='Name')
    email = forms.CharField(label='User Name')
    mail = forms.EmailField(label='E-mail Address')
    password = forms.CharField(widget=forms.PasswordInput, label='Password')
    confirm_password = forms.CharField(widget=forms.PasswordInput, label='Confirm Password')

    def clean(self):
        cleaned_data = super().clean()
        password = cleaned_data.get('password')
        confirm_password = cleaned_data.get('confirm_password')

        if password and confirm_password and password != confirm_password:
            raise forms.ValidationError("Passwords do not match.")

        return cleaned_data
    
    def __init__(self, *args, **kwargs):
        user_specific_parameter = kwargs.pop('state', None)
        super(DistrictCoordinatorForm, self).__init__(*args, **kwargs)

        # Filter the queryset based on the user-specific parameter
        if user_specific_parameter:
            self.fields['district'].queryset = District.objects.filter(state=user_specific_parameter)

class CityCoordinatorForm(forms.Form):
    TITLE_CHOICES = [
        ('SHRI', 'Shri'),
        ('SMT', 'Smt.'),
        ('DR', 'Dr.'),
        ('PROF', 'Prof.'),
    ]
    city = forms.ModelChoiceField(queryset=City.objects.all(), label='City')
    title = forms.ChoiceField(choices=TITLE_CHOICES, label='Title')
    name = forms.CharField(label='Name')
    email = forms.CharField(label='User Name')
    mail = forms.EmailField(label='E-mail Address')
    password = forms.CharField(widget=forms.PasswordInput, label='Password')
    confirm_password = forms.CharField(widget=forms.PasswordInput, label='Confirm Password')

    def clean(self):
        cleaned_data = super().clean()
        password = cleaned_data.get('password')
        confirm_password = cleaned_data.get('confirm_password')

        if password and confirm_password and password != confirm_password:
            raise forms.ValidationError("Passwords do not match.")

        return cleaned_data
    
    def __init__(self, *args, **kwargs):
        user_specific_parameter = kwargs.pop('district', None)
        super(CityCoordinatorForm, self).__init__(*args, **kwargs)

        # Filter the queryset based on the user-specific parameter
        if user_specific_parameter:
            self.fields['city'].queryset = City.objects.filter(district=user_specific_parameter)
    
class MandalCoordinatorForm(forms.Form):
    TITLE_CHOICES = [
        ('SHRI', 'Shri'),
        ('SMT', 'Smt.'),
        ('DR', 'Dr.'),
        ('PROF', 'Prof.'),
    ]
    mandal = forms.ModelChoiceField(queryset=Mandal.objects.all(), label='Mandal')
    title = forms.ChoiceField(choices=TITLE_CHOICES, label='Title')
    name = forms.CharField(label='Name')
    email = forms.CharField(label='User Name')
    mail = forms.EmailField(label='E-mail Address')
    password = forms.CharField(widget=forms.PasswordInput, label='Password')
    confirm_password = forms.CharField(widget=forms.PasswordInput, label='Confirm Password')

    def clean(self):
        cleaned_data = super().clean()
        password = cleaned_data.get('password')
        confirm_password = cleaned_data.get('confirm_password')

        if password and confirm_password and password != confirm_password:
            raise forms.ValidationError("Passwords do not match.")

        return cleaned_data
    
    def __init__(self, *args, **kwargs):
        user_specific_parameter = kwargs.pop('city', None)
        super(MandalCoordinatorForm, self).__init__(*args, **kwargs)

        # Filter the queryset based on the user-specific parameter
        if user_specific_parameter:
            self.fields['mandal'].queryset = Mandal.objects.filter(city=user_specific_parameter)

class DistrictForm(forms.ModelForm):
    class Meta:
        model = District
        fields = ('name',)

    def __init__(self, *args, **kwargs):
        super(DistrictForm, self).__init__(*args, **kwargs)
        self.fields['name'].label = 'New District Name'

class MandalForm(forms.ModelForm):
    class Meta:
        model = City
        fields = ('name',)

    def __init__(self, *args, **kwargs):
        super(MandalForm, self).__init__(*args, **kwargs)
        self.fields['name'].label = 'New City Name'

class CityForm(forms.ModelForm):
    class Meta:
        model = Mandal
        fields = ('name',)

    def __init__(self, *args, **kwargs):
        super(CityForm, self).__init__(*args, **kwargs)
        self.fields['name'].label = 'New Mandal Name'

class MembershipForm(forms.ModelForm):
    class Meta:
        model = Member
        fields = ('name', 'email','educational_qualification',
                  'specialization', 'designation', 'gender', 'workplace', 'membership_id',
                  'address_of_correspondence', 'permanent_address', 'mobile_number',
                  'upload_photo', 'upload_file')
