from django.contrib import admin
from .models import *
import csv
from django.http import HttpResponse

# Register your models here.
class MemberAdmin(admin.ModelAdmin):
    search_fields = ['name','state__name', 'district__name', 'city__name', 'mandal__name','educational_qualification', 'specialization', 'designation','workplace', 'membership_id', 'address_of_correspondence','permanent_address', 'mobile_number']
    list_display = ['name','state','district','city','mandal',]

    # def get_queryset(self, request):
    #     # Get the original queryset
    #     queryset = super(MemberAdmin, self).get_queryset(request)

    #     # Filter the queryset based on the current user's ID
    #     if not request.user.is_superuser:
    #         queryset = queryset.filter(user=request.user)

    #     return queryset

class MeetingMinutesAdmin(admin.ModelAdmin):
    search_fields = ['title', 'expert__name', 'members_attended__name','state__name', 'district__name', 'city__name']
    list_display = ['title', 'category', 'state', 'district', 'city', 'mandal', 'expert', 'meeting_date', 'meeting_time','upload_document']
    list_filter = ['category', 'state', 'district', 'city', 'mandal', 'expert', ('meeting_date', admin.DateFieldListFilter)]

    date_hierarchy = 'meeting_date'

    actions = ['export_to_csv']

    def export_to_csv(modeladmin, request, queryset):
        response = HttpResponse(content_type='text/csv')
        response['Content-Disposition'] = 'attachment; filename="meetings.csv"'

        writer = csv.writer(response)
        writer.writerow(['Title', 'Category', 'State', 'District', 'City', 'Mandal', 'Expert', 'Meeting Date', 'Meeting Time','Document'])

        for meeting in queryset:
            writer.writerow([
                meeting.title,
                meeting.category,
                meeting.state,
                meeting.district,
                meeting.city,
                meeting.mandal,
                meeting.expert,
                meeting.meeting_date,
                meeting.meeting_time,
                meeting.upload_document,
            ])

        return response

    export_to_csv.short_description = 'Export selected meetings to CSV'


admin.site.register(State)
admin.site.register(District)
admin.site.register(City)
admin.site.register(Mandal)
admin.site.register(Member,MemberAdmin)
admin.site.register(meeting_categories)
admin.site.register(meeting_minutes,MeetingMinutesAdmin)
admin.site.register(Experts)
admin.site.register(PasswordMapping)
admin.site.register(UserCategory)
admin.site.register(Counter)